<?php

class IndexController extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Handles what happens when user moves to URL/index/index - or - as this is the default controller, also
     * when user moves to /index or enter your application at base level
     */
    public function index()
    {
        $this->View->renderWithoutHeaderAndFooter('index/login');

    }

    public function authenticate()
    {
        $access=Validate::string(Request::post('access'));
        $results=Auth::checkAuthentication($access);
        $username=$results->username;
        $role=RoleModel::getUserRole($username);
        /*set the initial vehicleid*/
        Session::set('vehicleid',$role['vehicles'][0]);
        $this->View->render('index/index', array(
           'permissions' => RoleModel::getPermissionsForRole($role)
        ));
    }

    public function resetPassword()
    {
       $this->View->renderWithoutHeaderAndFooter('index/resetpassword');
    }



    public function logout()
    {
       Session::destroy();
       $this->View->renderWithoutHeaderAndFooter('index/login');
    }
}